﻿#include "precompiled.h"
#include "common.h"
#include "RTCore.h"

#include "ConsoleDefines.h"

//#define INIT_WINRT

#ifdef INIT_WINRTs
	#pragma comment(lib, "runtimeobject.lib")
	#include <wrl.h>
	#include <wrl/wrappers/corewrappers.h>
	using namespace Microsoft::WRL;
	using namespace Microsoft::WRL::Wrappers;

#endif

unique_ptr<RTCam::RTCore> g_appCore;

//--------------------------------------------------------------------------------------
// Entry point to the program. Initializes everything and goes into a message processing 
// loop. Idle time is used to render the scene.
//--------------------------------------------------------------------------------------
int WINAPI WinMain(_In_ HINSTANCE hInstance, _In_opt_ HINSTANCE hPrevInstance, _In_ LPSTR lpCmdLine, _In_ int nCmdShow)
{
	UNREFERENCED_PARAMETER(hPrevInstance);
	UNREFERENCED_PARAMETER(lpCmdLine);

	// Make sure DirectX Math library is supported by CPU
	if(!DirectX::XMVerifyCPUSupport()) {
		RTCam::ShowMessageBox(L"The DirectXMath Library doesn't support the current platform.", L"Error");
		return EXIT_FAILURE;
	}

#ifdef INIT_WINRT
	// Initialize WinRT. It will automatically uninitialize when the wrapper goes out of scope.
	RoInitializeWrapper winrtInitialize(RO_INIT_MULTITHREADED);
	if(FAILED(winrtInitialize)) {
		RTCam::ShowMessageBox(L"Failed to initialize WinRT", L"Error");
		return EXIT_FAILURE;
	}
#endif

	g_appCore = unique_ptr<RTCam::RTCore>(new RTCam::RTCore());

	if(FAILED(g_appCore->Initialize(hInstance, nCmdShow))) {
		RTCam::ShowMessageBox(L"The application failed to initialize", L"Error");
		return EXIT_FAILURE;
	}

#ifdef SHOW_CONSOLE
	AllocConsole();
	FILE* stream;
	freopen_s(&stream, "CONIN$", "r", stdin);
	freopen_s(&stream, "CONOUT$", "w", stdout);
	freopen_s(&stream, "CONOUT$", "w", stderr);
#endif

	// The main message loop.
	MSG msg = {0};
	while(msg.message != WM_QUIT) {
		// If there are any messages to be processed, handle them.
		// Otherwise, render.
		if(PeekMessage(&msg, nullptr, 0, 0, PM_REMOVE)) {
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		} else {
			// TODO: Make physics updates occur with fixed time steps
			g_appCore->FixedUpdate();
			g_appCore->Render();
		}
	}

	return (int) msg.wParam;
}

//--------------------------------------------------------------------------------------
// Called every time the application receives a message.
//--------------------------------------------------------------------------------------
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	PAINTSTRUCT ps;
	HDC hdc;
	HRESULT hr;

	switch (message) {
	case WM_KEYUP:
		g_appCore->OnKeyUp(wParam);
		break;

	case WM_PAINT:
		hdc = BeginPaint(hWnd, &ps);
		EndPaint(hWnd, &ps);
		break;

	case WM_DESTROY:
		PostQuitMessage(0);
		break;

	case WM_SIZE:
		hr = DefWindowProc(hWnd, message, wParam, lParam);
		g_appCore->OnResize();
		return hr;

	default:
		return DefWindowProc(hWnd, message, wParam, lParam);
	}

	return 0;
}